# -*- coding: utf-8 -*-
"""
Created on Thu Mar 11 12:45:37 2021

@author: Dyrvik
"""
import numpy as np
import matplotlib.pyplot as plt
import matplotlib.cm as cm
import matplotlib as mpl
#import seaborn as sns
import pandas as pd
import os
from mpl_toolkits.axes_grid1 import Divider, Size

"""Colourmaps"""
CM_SUBSECTION_GREENS = np.linspace(0.4, 1.0, 1000) 
COLOURS_GREENS = [ cm.Greens(x) for x in CM_SUBSECTION_GREENS ]

CM_SUBSECTION_ORANGES = np.linspace(0.3, 1.0, 1000) 
COLOURS_ORANGES = [ cm.Oranges(x) for x in CM_SUBSECTION_ORANGES ]

CM_SUBSECTION_BLUES = np.linspace(0.3, 1.0, 1000) 
COLOURS_BLUES = [ cm.Blues(x) for x in CM_SUBSECTION_BLUES ]

"""File handling"""
main_folder_path = os.path.dirname(os.path.abspath(__file__))
#main_folder_path = '\\\\?\\' + main_folder_path
data_folder_path = os.path.join(main_folder_path, 'Data', '008F79 TFB-masked', 'Integral Al')
export_folder_path = main_folder_path
# =============================================================================
# export_folder_name = 'Plots'
# export_folder_path = os.path.join(main_folder_path,export_folder_name)
# if not os.path.exists(export_folder_path):
#     os.mkdir(export_folder_path) # create folder if non-existent
# =============================================================================

selected_files = 'integral.txt' # in reality it is a "column average" from imagej, not an integral

"""Some constants for graphical settings"""
lw = 3
ticksize_major = 8
ticksize_minor = 8  

"""Prepare plots"""
#colour_array =  np.linspace(0, 999, len(selected_files))
colour_array = [200, 800]

fig = plt.figure(figsize=(7.5, 3))
h = [Size.Fixed(1.0), Size.Scaled(1.), Size.Fixed(.2)]
v = [Size.Fixed(0.7), Size.Scaled(1.), Size.Fixed(.5)]
divider = Divider(fig, (0, 0, 1, 1), h, v, aspect=False)
# The width and height of the rectangle are ignored.
ax = plt.axes([0.15, 0.15, 0.85, 0.85])
ax.set_xlabel('x position [µm]')
ax.set_ylabel('Intensity [a.u.]')
    
"""Plot the data"""
file_path = os.path.join(data_folder_path,selected_files)
df = pd.read_csv(file_path, delimiter='\t')
    
ax.plot(df.iloc[:,0]*10000, df.iloc[:,1], color=COLOURS_GREENS[int(colour_array[1])])

"""Axis settings"""
ax.yaxis.set_major_locator(mpl.ticker.MultipleLocator(1))
ax.yaxis.set_minor_locator(mpl.ticker.MultipleLocator(0.5))
ax.xaxis.set_major_locator(mpl.ticker.MultipleLocator(200))
ax.xaxis.set_minor_locator(mpl.ticker.MultipleLocator(100))

"""Annotation"""
ax.text(0.05, 0.95, r'$\mathregular{Al K_{\alpha}}$',
        horizontalalignment='left',
        verticalalignment='top',
        transform=ax.transAxes)

"""Legend"""
# =============================================================================
# leg = ax.legend(frameon = False)
# 
# # Right-aligning the legend
# vp = leg._legend_box._children[-1]._children[0]
# for c in vp._children:
#     c._children.reverse()
# vp.align="right"
# =============================================================================

"""Graphical details"""
plt.rcParams['font.size'] = 24
plt.rc('axes', labelsize=30)    # fontsize of the x and y labels
plt.rcParams['axes.linewidth'] = lw
plt.rcParams['lines.linewidth'] = lw*1.5

ax.xaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
ax.xaxis.set_tick_params(which='minor', size=ticksize_minor, width=lw)
ax.yaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
ax.yaxis.set_tick_params(which='minor', size=ticksize_minor, width=lw)

"""Exporting plots"""
plot_name = 'Plot EDS profile'
export_name_pdf = plot_name + '.pdf'
export_name_svg = plot_name + '.svg'
#export_name_eps = plot_name + '.eps'
pdf_path = os.path.join(export_folder_path,export_name_pdf)
svg_path = os.path.join(export_folder_path,export_name_svg)
#eps_path = os.path.join(export_folder_path,export_name_eps)
if len(pdf_path) > 255:
    warning_string = 'Warning: plot file path longer than 255 characters, downstream handling issues may occur. Path: ' + pdf_path
    print(warning_string)
fig.savefig(pdf_path, bbox_inches='tight')
fig.savefig(svg_path, bbox_inches='tight')
#fig.savefig(eps_path, bbox_inches='tight')
plt.close(fig)

